// LogFile.cpp : implementation file
//
#pragma warning( disable : 4201)


#include <stdio.h>
#include "LogFile.h"

/////////////////////////////////////////////////////////////////////////////
// CLogFile

void CLogFile::OpenLogFile( TCHAR* ptcFileName)
{

  m_FileHandle = CreateFile( ptcFileName,
                             GENERIC_WRITE,
                             0,
                             NULL,
                             OPEN_ALWAYS,
                             FILE_ATTRIBUTE_NORMAL,
                             0);

  if ( m_FileHandle == INVALID_HANDLE_VALUE )
  {
    TCHAR *psz = new TCHAR[512];
    wsprintf(psz, _T("File <%s> could not be opened"), ptcFileName);
    MessageBox(NULL, _T("Error"), psz, MB_ICONSTOP);
    delete [] psz;
    return;
  }
}

void CLogFile::CloseLogFile(void)
{
  if ( m_FileHandle != INVALID_HANDLE_VALUE)
    CloseHandle( m_FileHandle);
}

void CLogFile::WriteLogFile( DWORD dwNumOfEntries, float *pafEntryBuffer)
{
  // Create Logfile entries
  for ( DWORD dwIdx = 0; dwIdx < dwNumOfEntries; ++dwIdx)
  {
    char abBuffer[MAX_PATH];
    // Convert entry to string
    sprintf( &abBuffer[0],"%f\r\n", pafEntryBuffer[dwIdx]);
    size_t iSize = strlen(abBuffer);

    DWORD lNumberOfBytesWritten = 0;
    // Write to log file
    WriteFile( m_FileHandle,                    // handle to file
              abBuffer,                        // data buffer
              (DWORD)iSize,                           // number of bytes to write
              &lNumberOfBytesWritten,          // number of bytes written
              NULL                             // overlapped buffer
            );

  }
}
